<?php
/**------------------------------------------------------------------------
 * mod_vikwords
 * ------------------------------------------------------------------------
 * author    Valentina Arras - Extensionsforjoomla.com
 * copyright Copyright (C) 2021 e4j.com. All Rights Reserved.
 * @license - http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 * Websites: https://e4j.com
 * Technical Support:  templates@e4j.com
 * ------------------------------------------------------------------------
*/

defined('_JEXEC') or die ('Restricted access');

jimport('joomla.form.formfield');

class JFormFieldVikassets extends JFormField {
	protected $type = 'Vikassets';

	protected function getInput() {

		$is_j4 = false;
		$version = new JVersion();
		if (version_compare($version->getShortVersion(), '4.0') >= 0) {
			$is_j4 = true;
		}

		JHtml::_('jquery.framework', true, true);

		if ($is_j4) {
			if (!JHtml::isRegistered('behavior.modal')) {
				JHtml::register('behavior.modal', function() {
					return;
				});
			}
		} else {
			if (!JHtml::isRegistered('behavior.modal')) {
				JHtml::_('behavior.modal', 'a.modal');
			}
		}

		$document = JFactory::getDocument();
		$document->addStyleSheet(JURI::root().'modules/mod_vikwords/src/back-end-style.css');
		if ($is_j4) {
			$document->addStyleDeclaration('.fade:not(.show) {display: none !important;}');
		}

		return JHtml::script(Juri::root().'modules/mod_vikwords/src/back-end-script.js');
	}
	
}