<?php
/**------------------------------------------------------------------------
 * mod_vikwords
 * ------------------------------------------------------------------------
 * author    Valentina Arras - Extensionsforjoomla.com
 * copyright Copyright (C) 2018 e4j.com. All Rights Reserved.
 * @license - http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 * Websites: https://e4j.com
 * Technical Support:  templates@e4j.com
 * ------------------------------------------------------------------------
*/

defined('_JEXEC') or die ('Restricted access');

jimport('joomla.form.formfield');

class JFormFieldVikWordsmanager extends JFormField {
	protected $type = 'VikWordsmanager';

	protected function getInput() {
		$top_form = '<div id="vikwords-slides-container">'.
					'	<div id="vikwords-slides-add-wrapper">'.
					'		<a href="#add"><span class="icon-plus-circle"></span>'.JText::_('VIKCSADDSLIDE').'</a>'.
					'	</div>'.
					'	<div id="vikwords-slides-add-form">'.$this->loadFormData('add').'</div>'.
					'</div>';
		
		$edit_form = $this->loadFormData('edit');
		
		$data_form = '<div id="invisible" style="display: none;">'.
					'	<div class="vikwords-slider-entry">'.
					'		<div class="vikwords-slider-entry-inner">'.
					'			<div class="vikwords-slider-divtitle"><span class="vikwords-slider-title" title="'.JText::_('VIKTITLEDESC').'"></span></div>'.
					'			<div class="vikwords-slider-edit">'.
					//'			<span class="vikwords-slider-img"></span>'.
					'			<div class="vikwords-slider-remove"><a href="#remove" class="vikwords-slider-removebtn" title="'.JText::_('VIKCSREMOVESLIDE').'"><span class="icon-unpublish"></span>'.JText::_('VIKCSREMOVESLIDE').'</a></div>'.
					'			<div class="vikwords-slider-editbtn"><a href="#edit" class="vikwords-slider-editbtn" title="'.JText::_('VIKCSEDITSLIDE').'"><span class="icon-pencil-2"></span><span>'.JText::_('VIKCSEDITSLIDE').'</span></a></div>'.
					'			<div class="vikwords-slider-preview"><a rel="{handler:\'image\'}" class="vik-modal modal-img" title="'.JText::_('VIKCSPREVIEWSLIDE').'"><span class="icon-out-2"></span>'.JText::_('VIKCSPREVIEWSLIDE').'</a></div>'.			
					'			<div class="vikwords-slider-status"><div class="vikwords_publishediv"><span class="icon-radio-checked"></span><span class="vikwords_published">'.JText::_('VIKCSPUBLISHEDSLIDE').'</span></div><div class="vikwords_unpublisheddiv"><span class="icon-radio-unchecked"></span><span class="vikwords_unpublished">'.JText::_('VIKCSUNPUBLISHEDSLIDE').'</span></div></div>'.
					'		</div></div>'.
					'		<div class="vikwords-slider-editcontainer">'.
					'			<div class="vikwords-slider-editor">'.$edit_form.'</div>'.
					'		</div>'.
					'	</div>'.
					'</div>';
		
		$slides_list = '<div id="vikwords-allslides"></div>';

		$val_container = '<textarea name="'.$this->name.'" id="'.$this->id.'" style="display: none;">'.$this->value.'</textarea>';
		
		return $data_form . $top_form . $slides_list . $val_container;
	}
	
	private function loadFormData($type = 'add') {
		$is_j4 = false;
		$version = new JVersion();
		if (version_compare($version->getShortVersion(), '4.0') >= 0) {
			$is_j4 = true;
		}

		$form_data = '';
		$media_mng_link_add  = 'index.php?option=com_media&view=images&tmpl=component&asset=com_modules&author=&fieldid=jform_params_img&folder=';
		$media_mng_link_edit = 'index.php?option=com_media&view=images&tmpl=component&asset=&author=&fieldid=jform_params_edit_img&folder=';

		if ($type == 'add') {
			// Joomla JS function for Media Manager
			$jscript = '	function jInsertFieldValue(value,id) {'."\n";
			$jscript .= '		var old_id = document.getElementById(id).value;'."\n";
			$jscript .= '		if (old_id != id) {'."\n";
			$jscript .= '			document.getElementById(id).value = value;'."\n";
			$jscript .= '		}'."\n";
			$jscript .= '	}'."\n";
			JFactory::getDocument()->addScriptDeclaration($jscript);
			//
			// Slide IMG
			$form_data .= '<div class="vikwords-slideparam-block">';
			$form_data .= '	<div class="control-label"><label>'.JText::_('VIKCSIMGBGSLIDE').'</label></div>';
			if ($is_j4) {
				$form_data .= $this->getMediaField('jform[params][img]', null, ['id' => 'jform_params_img', 'class'=> 'vikwordsparam_'.$type.'_image']);
			} else {
				$form_data .= '<div class="input-group">';
				$form_data .= '	<input type="text" name="jform[params][img]" id="jform_params_img" value="" class="form-control vikwordsparam_'.$type.'_image" />';
				$form_data .= '	<a class="btn modal modal-media" title="'.JText::_('JSELECT').'" href="' . $media_mng_link_add . '" rel="{handler: \'iframe\', size: {x: 800, y: 500}}">'.JText::_('JSELECT').'</a>';
				$form_data .= '	<a title="'.JText::_('JCLEAR').'" class="btn btn-outline-secondary" href="#" onclick="javascript:document.getElementById(\'jform_params_img\').value=\'\';return false;">'.JText::_('JCLEAR').'</a></p>';
				$form_data .= '</div>';
			}
			$form_data .= '</div>';
		} else {
			if ($is_j4) {
				$form_data .= '<div class="vikwords-slideparam-block" style="display: block !important;">';
				$form_data .= '	<div class="control-label"><label>'.JText::_('VIKCSIMGBGSLIDE').'</label></div>';
				$form_data .= $this->getMediaField('jform_params_edit_img', null, ['id' => 'jform_params_edit_img', 'class'=> 'vikwordsparam_'.$type.'_image']);
				$form_data .= '</div>';
			} else {
			$form_data .= '<div class="vikwords-slideparam-block">';
			$form_data .= '	<input type="text" name="jform_params_edit_img" id="jform_params_edit_img" value="" class="form-control vikwordsparam_'.$type.'_image" />';
			$form_data .= '	<a class="btn modal modal-media" title="'.JText::_('JSELECT').'" href="' . $media_mng_link_edit . '" target="_blank" rel="{handler: \'iframe\', size: {x: 800, y: 500}}">'.JText::_('JSELECT').'</a>';
			$form_data .= '	<a title="'.JText::_('JCLEAR').'" href="#" onclick="javascript:document.getElementById(\'jform_params_edit_img\').value=\'\';return false;" class="btn btn-outline-secondary modal-media-clear">'.JText::_('JCLEAR').'</a>';
			$form_data .= '</div>';
			}
		}
		//Slide Name Customer
		$form_data .= '<div class="vikwords-slideparam-block"><div class="control-label"><label title="'.JText::_('VIKTITLEDESC').'">'.JText::_('VIKTITLE').'</label></div><input type="text" class="form-control vikwordsparam_'.$type.'_title" /></div>';
		//Slide Role Customer
		$form_data .= '<div class="vikwords-slideparam-block"><div class="control-label"><label title="'.JText::_('VIKROLEDESC').'">'.JText::_('VIKROLE').'</label></div><input type="text" class="form-control vikwordsparam_'.$type.'_role" /></div>';
		//Slide Title
		$form_data .= '<div class="vikwords-slideparam-block"><div class="control-label"><label title="'.JText::_('VIKROLETITLE_DESC').'">'.JText::_('VIKROLETITLEDESC').'</label></div><input type="text" class="form-control vikwordsparam_'.$type.'_title_desc" /></div>';
		//Slide Description
		$form_data .= '<div class="vikwords-slideparam-block"><div class="control-label"><label title="'.JText::_('VIKCSSLIDECAPTIONDESC').'">'.JText::_('VIKCSSLIDECAPTION').'</label></div><textarea rows="4" cols="50" class="form-control vikwordsparam_'.$type.'_description"></textarea></div>';
		//Testimonial Rate
		$form_data .= '<div class="vikwords-slideparam-block"><div class="control-label"><label title="'.JText::_('VIKCSSLIDERATEDESC').'">'.JText::_('VIKCSSLIDERATE').'</label></div><input type="number" step="1" min="0" max="5" class="form-control vikwordsparam_'.$type.'_rate" /></div>';
		//Slide Published
		$form_data .= '<div class="vikwords-slideparam-block"><div class="control-label"><label>'.JText::_('VIKCSSLIDESTATUS').'</label></div><select class="custom-select vikwordsparam_'.$type.'_published"><option value="1">'.JText::_('VIKCSPUBLISHEDSLIDE').'</option><option value="0">'.JText::_('VIKCSUNPUBLISHEDSLIDE').'</option></select></div>';
		//Add/Cancel buttons
		$form_data .= '<div class="vikwords-slideparam-block vikwords-slideparam-block-'.$type.'"><a href="#save" class="btn btn-success">'.JText::_('VIKCSBTNADDSLIDE').'</a><a href="#cancel" class="btn btn-outline-danger">'.JText::_('VIKCSBTNCANCSLIDE').'</a></div>';
				
		return '<div class="vikwords-newslide-cont"><div class="vikwords-newslide-cont-'.$type.'">'.$form_data.'</div></div>';
	}
	/**
	 * Method used to obtain a Joomla media form field.
	 * Compatible with J4.
	 *
	 * @return 	string 	The media in HTML.
	 *
	 * @since 	September 2021
	 */
	private function getMediaField($name, $value = null, array $data = array())
	{
		// init media field
		$field = new JFormFieldMedia(null, $value);
		// setup an empty form as placeholder
		$field->setForm(new JForm('vikwords.media'));

		// force field attributes
		$data['name']  = $name;
		$data['value'] = $value;

		/**
		 * J4.x requires us to use the magic method to set the properties id and types
		 * or the media manager won't work in case of multiple instances on the same page,
		 * nor would it display any image unless the proper types is passed.
		 */

		static $index = 1;
		// use an incremental value for the id
		$field->id = preg_replace("/[^A-Za-z0-9\-_]+/", '', $name) . $index++;
		// accept all images
		$field->types = 'images';

		if (empty($data['previewWidth']))
		{
			// there is no preview width, set a defualt value
			// to make the image visible within the popover
			$data['previewWidth'] = 480;
		}

		// render the field	
		return $field->render('joomla.form.field.media', $data);
	}
}
