<?php  
/**------------------------------------------------------------------------
 * mod_vikwords
 * ------------------------------------------------------------------------
 * author    Valentina Arras - Extensionsforjoomla.com
 * copyright Copyright (C) 2021 e4j.com. All Rights Reserved.
 * @license - http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 * Websites: https://e4j.com
 * Technical Support:  templates@e4j.com
 * ------------------------------------------------------------------------
*/

defined('_JEXEC') or die('Restricted Area'); 

$document = JFactory::getDocument();

$get_sentence_layout = $params->get('type_layout');
$get_font_library = $params->get('fontlibrary');
$get_img_position = $params->get('img_position');
$get_time_autoplay = $params->get('time_autoplay');

//Fade
$get_width = $params->get('width');
$get_height = $params->get('height');
$get_color = $params->get('colortitle');
$get_quotes = $params->get('addquotes');

//Grid Scroll
$numb_xrow = $params->get('numb_sentrow');
$autoplayparam = $params->get('autoplay');
$autoplayparam_values = intval($autoplayparam) == 1 ? "true" : "false";

$pagination = $params->get('pagination');
$pagination_values = intval($pagination) == 1 ? "true" : "false";

$navigation = $params->get('navigation');
$navigation_values = intval($navigation) == 1 ? "true" : "false";

$get_delay = $params->get('txt_delay');
$get_fadein = $params->get('txt_fadein');
$get_fadeout = $params->get('txt_fadeout');

JHtml::_('stylesheet', JURI::root().'modules/mod_vikwords/mod_vikwords.css');

if($get_font_library == 1) {
	JHtml::_('stylesheet', JURI::root().'modules/mod_vikwords/src/fontawesome-all.min.css');
}

if($get_sentence_layout == 1) {
	JHtml::_('stylesheet', JURI::root().'modules/mod_vikwords/src/owl.carousel.min.css');

	if (intval($params->get('loadjq')) == 1 ) {
		JHtml::_('jquery.framework', true, true);
	}
	JHtml::_('script', JURI::root().'modules/mod_vikwords/src/owl.carousel.min.js');
}
$arrslide = array();
$slidejstr = $params->get('vikwordstabs', '[]');
$slides = json_decode($slidejstr);

// foreach($slides as $value)
// {
// 	// $string = str_replace('[leftbracket]', '<', $value->description);
// 	// $string = str_replace('[rightbracket]', '>', $string);

// 	echo '<pre>' . print_r($value->description, true) . '</pre>';
// }

if (count($slides)) {
	foreach ($slides as $sk => $slide) {
		if ((int)$slide->published < 1) {
			continue;
		}
		
		if(!empty($slide->image)) {

			/* 
			 * @since v2.2.4
			 * Changed and print the testimonial also if the image is empty. 
			 * @TODO: Check on Joomla4 why on "edit" function the image has been not correctly saved.
			 */

			$imgabpath = JPATH_SITE . DIRECTORY_SEPARATOR . str_replace('/', DIRECTORY_SEPARATOR, $slide->image);
			/**
			 * Images path may contain information about their size, like:
			 * images/background-04.jpg#joomlaImage://local-images/background-04.jpg?width=1920&height=1080
			 * So we get rid of anything after the hash.
			 * 
			 * @joomla4
			 */
			$img_hash = strpos($imgabpath, '#');
			if ($img_hash !== false) {
				$imgabpath = substr_replace($imgabpath, '', $img_hash);
			}
		} else {
			$imgabpath = "";
		}

		$slide_item = "";

		$slide_text_description = str_replace('[leftbracket]', '<', $slide->description);
	    $slide_text_description = str_replace('[rightbracket]', '>', $slide_text_description);

		if($get_sentence_layout == 0) {	
			$slide_item .= "<div class=\"vikqt_box vikqt-item-fade vikqt-item-lay_". $get_img_position ."\">";
				$slide_item .= "<div class=\"vikqt-item-content vikqt-item-img_". $get_img_position ."\">";
					if (is_file($imgabpath)) {
						$slide_item .= "<div class=\"vikqt_image\"><img src=".JURI::root().$slide->image." alt=".$slide->title." /></div>";
					}
					$slide_item .= "<div class=\"vikqt_text_cont\">";
						if($get_quotes == 1) {
							$slide_item .= "<div class=\"vikqt-quotes\"><i class=\"fas fa-quote-left\"></i></div>";
						}		
						if(!empty($slide->description)) {
							$slide_item .= "<div class=\"vikqt_desc\">";
								$slide_item .= $slide_text_description;
								if($get_img_position == "right" || $get_img_position == "left") {
									if(!empty($slide->title)) {
										$slide_item .= "<div class=\"vikqt_title\" style=\"color:".$get_color.";\">".$slide->title."</div>";
									}
								}
							$slide_item .= "</div>";
						}
					$slide_item .= "</div>";
				$slide_item .= "</div>";
				if($get_img_position == "up" || $get_img_position == "down") {
					if(!empty($slide->title)) {
						$slide_item .="<div class=\"vikqt_title\" style=\"color:".$get_color.";\">".$slide->title."</div>";
					}
				}
			$slide_item .= "</div>";
		} else {
			$slide_item .= "<div class=\"vikqt_box vikqt-item-grid vikqt-item-lay_".$get_img_position."\">";
				$slide_item .= "<div class=\"vikqt-item-content vikqt-item-img_".$get_img_position."\">";
					if (is_file($imgabpath)) {
						$slide_item .= "<div class=\"vikqt_image\"><img src=".JURI::root().$slide->image." alt=".$slide->title." /></div>";
					}
					$slide_item .= "<div class=\"vikqt_text_cont\">";
						if($get_quotes == 1) {
							$slide_item .= "<div class=\"vikqt-quotes\"><i class=\"fas fa-quote-left\"></i></div>";
						}
						if(!empty($slide->description)) {
							$slide_item .= "<div class=\"vikqt_desc\">";
								$slide_item .= $slide_text_description;
								if($get_img_position == "right" || $get_img_position == "left") {
									if(!empty($slide->title)) {
										$slide_item .= "<div class=\"vikqt_title\" style=\"color:".$get_color.";\">".$slide->title."</div>";
									}
								}
							$slide_item .= "</div>";
						}
					$slide_item .= "</div>";
				$slide_item .= "</div>";
				if($get_img_position == "up" || $get_img_position == "down") {
					if(!empty($slide->title)) {
					$slide_item .= "<div class=\"vikqt_title\" style=\"color:".$get_color.";\">".$slide->title."</div>";
					}
				}
				
			$slide_item .= "</div>";
			
		}
		$arrslide[] = $slide_item;
	}		
}

 ?>
 <?php 
 //If Layout list Fade 
 if($get_sentence_layout == 0) { ?>
	<div class="vikqt-container vikqt-list-l">
		<div class="vikqt-slide" style="width:<?php echo $get_width; ?>; height:<?php echo $get_height ?>;">
		<?php
		    if (is_array($arrslide)) {
				foreach($arrslide as $vsl) {			
					echo $vsl;
				}
			}
		?>
		</div>
	</div>
 <?php } else if($get_sentence_layout == 1) { ?>
 	<div class="vikqt-container vikqt-grid-l container">
 		<div id="vikqt-inner" class="owl-carousel vikqt-items row-fluid">
 		<?php
		    if (is_array($arrslide)) {
				foreach($arrslide as $vsl) {			
					echo $vsl;
				}
			}
		?>
		</div>
 	</div>
 <?php } ?>



<?php 
if($get_sentence_layout == 0) { ?>
	<script language="JavaScript" type="text/javascript">
		jQuery(function($) {
		(function() {

	    var quotes = $(".vikqt_box");
	    var quoteIndex = -1;
	    
	    function showNextQuote() {
	        ++quoteIndex;
	        quotes.eq(quoteIndex % quotes.length)
	            .fadeIn(<?php echo $get_delay; ?>)
	            .delay(<?php echo $get_fadein; ?>)
	            .fadeOut(<?php echo $get_fadeout; ?>, showNextQuote);
	    }
	    
	    showNextQuote();
	    
	})() 
	});
	</script>
<?php } else { ?>
	<script type="text/javascript">
	jQuery(document).ready(function(){ 
		jQuery("#vikqt-inner").owlCarousel({
			items : <?php echo $numb_xrow; ?>,
			autoplay : <?php echo $autoplayparam_values; ?>,
			navigation : <?php echo $navigation_values; ?>,
			pagination : <?php echo $pagination_values; ?>,
			lazyLoad : true,
			loop: true,
			rewind: false,
			responsiveClass:true,
		    responsive:{
		        0:{
		            items: 1,
		            nav: true,
					loop: false
		        },
		        600:{
		            items: 1,
		            nav: false,
					loop: false
		        },
		        1000:{
		            items: 1,
		            nav: true
		        }
		    }
		});
	});
	</script>
<?php } ?>

