<?php  
/**------------------------------------------------------------------------
 * mod_vikthumbnails
 * ------------------------------------------------------------------------
 * author    Valentina Arras - Extensionsforjoomla.com
 * copyright Copyright (C) 2016 extensionsforjoomla.com. All Rights Reserved.
 * @license - http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 * Websites: http://www.extensionsforjoomla.com
 * Technical Support:  templates@extensionsforjoomla.com
 * ------------------------------------------------------------------------
*/

defined('_JEXEC') or die('Restricted Area'); 
//jimport( 'joomla.methods' );
//JHTML::_('behavior.mootools');

$document = JFactory::getDocument();
$get_bootstrap = $params->get('enable_bootstrap');

JHtml::_('stylesheet', JURI::root().'modules/mod_vikthumbnails/src/mod_vikthumbnails.css');
JHtml::_('stylesheet', JURI::root().'modules/mod_vikthumbnails/src/jquery.fancybox.css');

JHtml::_('jquery.framework', true, true);
JHtml::_('script', JURI::root().'modules/mod_vikthumbnails/src/jquery.fancybox.js');

if($get_bootstrap == 1) {
	JHtml::_('stylesheet', JURI::root().'modules/mod_vikthumbnails/src/bootstrap/bootstrap.min.css');	
}

$arrslide = [];

$mask = $params->get('enablemask');
$get_colormask = $params->get('colormask', '#000000');
$get_opacitymask = $params->get('opacitymask');
$get_enable_link = $params->get('enable_link');
$get_effects = $params->get('effects');
$first_height = "";

$get_numb = $params->get('numb-items');

$slidejstr = $params->get('viktab', '[]');
$slides = json_decode($slidejstr);
if (count($slides)) {
	foreach ($slides as $sk => $slide) {
		if((int)$slide->published < 1 || empty($slide->image)) {
			continue;
		}
		$imgabpath = JPATH_SITE . DIRECTORY_SEPARATOR . str_replace('/', DIRECTORY_SEPARATOR, $slide->image);

		/**
		 * Images path may contain information about their size, like:
		 * images/background-04.jpg#joomlaImage://local-images/background-04.jpg?width=1920&height=1080
		 * So we get rid of anything after the hash.
		 * 
		 * @joomla4
		 */
		$img_hash = strpos($imgabpath, '#');
		if ($img_hash !== false) {
			$imgabpath = substr_replace($imgabpath, '', $img_hash);
		}

		if (is_file($imgabpath)) {
			if(!($sk > 0)) {
				$img_size = @getimagesize($imgabpath);
				$first_height = $img_size && !($first_height > 0) ? $img_size[1] : $first_height;
			}	
				if($mask == 1) {
					$slider_entry = '<div style="background:'.$get_colormask.';">';
					$slider_entry .= '<img class="vikthumbnail-img" src="'.JURI::root().$slide->image.'" alt="'.$slide->title.'" style="opacity: '. $get_opacitymask .'"/>';
				} else {
					$slider_entry = '<div>';
					$slider_entry .= '<img class="vikthumbnail-img" src="'.JURI::root().$slide->image.'" alt="'.$slide->title.'" />';
				}
					$slider_entry .= '<div class="vikthumbnail-figcaption">';
					if(!empty($slide->readmore)) {
						$slider_entry .= '<a class="vikthumbnail-readmoremask" href="'.$slide->readmore.'"></a>';
					}
					$slider_entry .= '<div>';
					if(!empty($slide->title)) {
						$slider_entry .= '	<div class="vikthumbnail-title"><h3>'.$slide->title.'</span></h3>';
					}
					if(!empty($slide->caption)) {
						$slider_entry .= '	<div class="vikthumbnail-desc"><p><span class="vikthumbnail-desctxt">'.$slide->caption.'</span>';
						if($get_enable_link == 1) {
							$slider_entry .= '	<a class="vikthumbnail-link-btn" href="'.$slide->readmore.'"><span>'.$params->get('readmore_txt').'</span></a>';
						}
						$slider_entry .= ' </p>';	
					}
					$slider_entry .= ' </div>';
				$slider_entry .= ' </div>';

			$slider_entry .= '</div>';

			$arrslide[] = $slider_entry;
		}
	}
}

?>
<div id="vikthumbnail_container" class="container-fluid vikthumbnail-container <?php echo $params->get('moduleclass_sfx'); ?>">
	<div class="vikthumbnail-inner vikthumbnail-grid row justify-content-center">
	    <?php
	    if (is_array($arrslide)) {
			foreach($arrslide as $vsl) {
				echo "<figure class=\"col-12 col-md-".$get_numb." ".$get_effects."\">";
				echo "<div class=\"vikthumbnail-item-inner\">";
				echo $vsl;
				echo "</div>";
				echo "</figure>";
			}
		}
		?>
	</div>
</div>

<script type="text/javascript">
jQuery(document).ready(function() {
	jQuery("a.vthb-opener").fancybox({
		'titleShow' : true,
		'titlePosition'  : 'inside',
		'transitionIn' : 'none',
		'transitionOut' : 'none',
		"helpers": {
			"overlay": {
				"locked": false
			}
		},
		"autoScale": true,
		"padding": 0,
		"fitToView" : true,
		"autoSize" : true,
	});
	jQuery("a.vthb-opener-video").fancybox({
		'type' : 'iframe',
		'titleShow' : true,
		'titlePosition'  : 'inside',
		'transitionIn' : 'none',
		'transitionOut' : 'none',
		"helpers": {
			"overlay": {
				"locked": false
			}
		},
		"autoScale": true,
		"padding": 0,
		"fitToView" : true,
		"autoSize" : true,
	});
});
</script>
	