<?php  
/**------------------------------------------------------------------------
 * mod_vikspeakers
 * ------------------------------------------------------------------------
 * author    Valentina Arras - e4j.com
 * copyright Copyright (C) 2018 e4j.com. All Rights Reserved.
 * @license - http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 * Websites: https://e4j.com
 * Technical Support:  templates@e4j.com
 * ------------------------------------------------------------------------
*/

defined('_JEXEC') or die('Restricted Area'); 

$document = JFactory::getDocument();
JHtml::_('stylesheet', JURI::root().'modules/mod_vikspeakers/src/mod_vikspeakers.css');
JHtml::_('stylesheet', JURI::root().'modules/mod_vikspeakers/src/fontawesome.min.css');

$arrslide = array();

$readmtext = $params->get('readmoretext');
$get_numb = $params->get('numbrow');
$get_textarea_above = $params->get('textarea_above');
$itemwidth = (100/$get_numb);
$first_height = '';

$slidejstr = $params->get('vikspeakersimages', '[]');
$slides = json_decode($slidejstr);

if (count($slides)) {
	foreach ($slides as $sk => $slide) {
		if((int)$slide->published < 1 || empty($slide->image)) {
			continue;
		}
		$imgabpath = JPATH_SITE . DIRECTORY_SEPARATOR . str_replace('/', DIRECTORY_SEPARATOR, $slide->image);
		/**
		 * Images path may contain information about their size, like:
		 * images/background-04.jpg#joomlaImage://local-images/background-04.jpg?width=1920&height=1080
		 * So we get rid of anything after the hash.
		 * 
		 * @joomla4
		 */
		$img_hash = strpos($imgabpath, '#');
		if ($img_hash !== false) {
			$imgabpath = substr_replace($imgabpath, '', $img_hash);
		}

		if (is_file($imgabpath)) {
			if(!($sk > 0)) {
				$img_size = @getimagesize($imgabpath);
				$first_height = $img_size && !($first_height > 0) ? $img_size[1] : $first_height;
			}
			$slider_entry = '<div id="vikmodsp-inner" class="vikmodsp-inner">';
				$slider_entry .= '<div class="vikmodsp-divimg">';
					$slider_entry .= '<img class="vikmodsp-img" src="'.JURI::root().$slide->image.'" alt="'.$slide->title.'"/><span class="vikmodsp-imgmasktwo"></span><a class="vikmodsp-imgmask" href="'.$slide->readmore.'"></a>';
				$slider_entry .= '</div>';
				$slider_entry .= '<figcaption>';
				if(!empty($slide->title)) {
					$slider_entry .= '	<div class="vikmodsp-name"><span>'.$slide->title.'</span></div>';
				}
				if(!empty($slide->job)) {
					$slider_entry .= '	<div class="vikmodsp-job"><span>'.$slide->job.'</span></div>';
				}
				if(!empty($slide->caption)) {
					$slider_entry .= '	<div class="vikmodsp-descr"><span>'.$slide->caption.'</span></div>';
				}
				$slider_entry .= ' <div class="vikmodsp-socials">';
					if(!empty($slide->facebook)) {
						$slider_entry .= '	<span class="vikmodsp-socials-link"><a href="'.$slide->facebook.'"><img class="vikmodsp-ico-links" src="'.JURI::root().'modules/mod_vikspeakers/webfonts/facebook-f-brands.svg" alt="Facebook" /></a></span>';
					}
					if(!empty($slide->twitter)) {
						$slider_entry .= '	<span class="vikmodsp-socials-link vikmodsp-socials-twitter"><a href="'.$slide->twitter.'" target="_blank"><img class="vikmodsp-ico-links" src="'.JURI::root().'modules/mod_vikspeakers/webfonts/twitter-brands.svg" alt="Twitter" /></a></span>';
					}
					if(!empty($slide->google)) {
						$slider_entry .= '	<span class="vikmodsp-socials-link vikmodsp-socials-google"><a href="'.$slide->google.'" target="_blank"><img class="vikmodsp-ico-links" src="'.JURI::root().'modules/mod_vikspeakers/webfonts/google-plus-g-brands.svg" alt="Google Plus" /></a></span>';
					}
					if(!empty($slide->linkedin)) {
						$slider_entry .= '	<span class="vikmodsp-socials-link vikmodsp-socials-linkedin"><a href="'.$slide->linkedin.'" target="_blank"><img class="vikmodsp-ico-links" src="'.JURI::root().'modules/mod_vikspeakers/webfonts/linkedin-in-brands.svg" alt="LinkedIn" /></a></span>';
					}
				$slider_entry .= ' </div>';
				
			$slider_entry .= '</figcaption>'.
							'</div>';
			$arrslide[] = $slider_entry;
			
		}
	}
}
?>
<div id="vikmodsp_container" class="vikmodsp_container">
	<?php if(!empty($get_textarea_above)) { ?>
	<div class="vikmodsp_text"><?php echo $get_textarea_above; ?></div>
	<?php } ?>
	<div class="vikmodsp-cnt-speakers">
	    <?php
	    if (is_array($arrslide)) {
			foreach($arrslide as $vsl) {
				echo "<figure class=\"vikmodsp-speaker\" style=\"width:".$itemwidth."%;\">";
				echo $vsl;
				echo "</figure>";
			}
		}
		?>
	</div>
</div>

<script>
	jQuery(document).ready(function() {
    jQuery('img[src$=".svg"]').each(function() {
        var $img = jQuery(this);
        var imgURL = $img.attr('src');
        var attributes = $img.prop("attributes");

        jQuery.get(imgURL, function(data) {
            // Get the SVG tag, ignore the rest
            var $svg = jQuery(data).find('svg');

            // Remove any invalid XML tags
            $svg = $svg.removeAttr('xmlns:a');

            // Loop through IMG attributes and apply on SVG
            jQuery.each(attributes, function() {
                $svg.attr(this.name, this.value);
            });

            // Replace IMG with SVG
            $img.replaceWith($svg);
        }, 'xml');
    });
});
</script>