<?php
/**
 * @package     e4j.VikUpdater
 * @subpackage  Library.Network
 * @copyright   Copyright (C) 2023 e4j - Extensionsforjoomla.com. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace E4J\VikUpdater\Network;

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

/**
 * This class is used to access information about the server.
 *
 * @since 1.0
 * @since 1.3  Renamed from Server.
 * @since 1.4  Renamed from VUPNetworkServer.
 */
abstract class Server
{
	/**
	 * Access the values stored in the $_SERVER superglobal.
	 *
	 * @param   string  $key      The value to get.
	 * @param   mixed   $default  The value to use in case the key is not set.
	 * @param   string  $filter   The filter type to clean the value.
	 *
	 * @return  mixed   The value of the key.
	 */
	public static function get($key, $default = '', $filter = 'string')
	{
		return \JFactory::getApplication()->input->server->get($key, $default, $filter);
	}

	/**
	 * Return the base domain name of the server.
	 *
	 * @return  string  The domain name.
	 */
	public static function base()
	{
		// try HTTP_HOST info
		$base = self::get('HTTP_HOST', false);

		if ($base)
		{
			return $base;
		}
		
		// try SERVER_NAME info
		$base = self::get('SERVER_NAME', false);

		if ($base)
		{
			return $base;
		}

		// return Joomla root
		return \JUri::root();
	}
}
