<?php
/**
 * @package     e4j.VikUpdater
 * @subpackage  Library.Software.Classes
 * @copyright   Copyright (C) 2023 e4j - Extensionsforjoomla.com. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace E4J\VikUpdater\Software\Adapters;

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

use E4J\VikUpdater\Software\Version as SoftwareVersion;

/**
 * This class is used to check the integrity of the specified VIK software version.
 *
 * @since 1.0
 * @since 1.3  Renamed from VikSoftware.
 * @since 1.4  Renamed from VUPSoftwarePluginVik.
 */
abstract class VikAdapter extends SoftwareVersion
{
	/**
	 * Check if the specified version is valid or not.
	 * The version is valid in case the version and SKU properties are not empty.
	 *
	 * @return 	bool  True if the instance is valid, otherwise false.
	 */
	public function check()
	{
		return $this->getVersion() !== null && $this->getSku() !== null;
	}
}
