<?php
/**
 * @package     Joomla.Plugin
 * @subpackage  e4j.VikUpdater
 * @copyright   Copyright (C) 2023 e4j - Extensionsforjoomla.com. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

jimport('joomla.installer.installer');
jimport('joomla.installer.helper');

/**
 * Script file of VikUpdater plugin.
 *
 * @since 1.0
 */
class plgE4jVikupdaterInstallerScript
{
	/**
	 * Method to install the component.
	 *
	 * @return  void
	 */
	function install($parent)
	{
		$dbo = JFactory::getDbo();

		/**
		 * Auto-enable the plugin after the installation.
		 * 
		 * @since 1.2.2
		 */
		$q = $dbo->getQuery(true)
			->update($dbo->qn('#__extensions'))
			->set($dbo->qn('enabled') . ' = 1')
			->where([
				$dbo->qn('element') . ' = ' . $dbo->q('vikupdater'),
				$dbo->qn('folder') . ' = ' . $dbo->q('e4j'),
			]);

		$dbo->setQuery($q);
		$dbo->execute();
	}

	/**
	 * Method to uninstall the component.
	 *
	 * @return  void
	 */
	function uninstall($parent)
	{

	}

	/**
	 * Method to update the component.
	 *
	 * @return  void
	 */
	function update($parent)
	{
		/**
		 * Some folders have been renamed by making the first letter upper-case.
		 * In some web-servers this could lead to a weird behavior where the deprecated
		 * folder is taken in place of the correct one.
		 * 
		 * For this reason, we had to move the new libraries into a new folder:
		 * from "helpers" to "libraries".
		 * 
		 * At this point, we can consider to manually delete the deprecated folder.
		 * 
		 * @since 1.4.2
		 */
		$deprecatedHelpers = JPATH_SITE . '/plugins/e4j/vikupdater/helpers';

		// does the folder exist?
		if (JFolder::exists($deprecatedHelpers))
		{
			// yep, delete it
			JFolder::delete($deprecatedHelpers);
		}
	}

	/**
	 * Method to run before an install/update/uninstall method.
	 *
	 * @return  void
	 */
	function preflight($type, $parent)
	{
		
	}

	/**
	 * Method to run after an install/update/uninstall method.
	 *
	 * @return  void
	 */
	function postflight($type, $parent)
	{
		
	}
}
